/*
* drv_dualos.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

#ifndef __DRV_DUALOS_H__
#define __DRV_DUALOS_H__

#include "cam_os_wrapper.h"

#define ENABLE_NBLK_CALL    1

#define INTEROS_SC_L2R_HANDSHAKE        (0x800)
#define INTEROS_SC_L2R_RTK_CLI          (0x801)
#define INTEROS_SC_L2R_RTK_LOG          (0x802)
#define INTEROS_SC_L2R_SCR_FW_ENABLE    (0x803)
#define INTEROS_SC_L2R_SCR_FW_DISABLE   (0x804)
#define INTEROS_SC_L2R_RTK_ASSERT       (0x805)
#define INTEROS_SC_L2R_RSQ_INIT         (0x100)
#define INTEROS_SC_L2R_CALL             (0x808)
#define INTEROS_SC_L2R_ACK_RTK_SIG_BLK  (0x80A)
#define INTEROS_SC_L2R_AMP_RTK_CPU_USAGE    (0x80B)
#define INTEROS_SC_L2R_SWTOE                (0xfe000000)
#define INTEROS_SC_L2R_RPMSG_HANDSHAKE      (0x900)
#define INTEROS_SC_L2R_RPMSG_NOTIFY         (0x901)

#define IPI_NR_RTOS_2_LINUX_CALL_REQ        8
#define IPI_NR_RTOS_2_LINUX_CALL_RESP       9
#define IPI_NR_LINUX_2_RTOS_CALL_REQ        10
#define IPI_NR_LINUX_2_RTOS_CALL_RESP       11
#define IPI_NR_RTOS_2_LINUX_NBLK_CALL_REQ   12
#define IPI_NR_RTOS_2_LINUX_RPMSG           13
#define IPI_NR_REROUTE_SMC                  14
#define IPI_NR_LINUX_2_RTOS_RPMSG           15

#define	RTKINFO_FIQCNT(c)	if (_rtk) _rtk->fiq_cnt++
#define	RTKINFO_FFIQTS()	_rtk->ffiq_ts = (unsigned int)(_getsysts() - epiod);
#define	RTKINFO_LOADNSTS()	_rtk->ldns_ts = (unsigned int)(_getsysts() - epiod);
#define	RTKINFO_TTFF_ISP()	if (!_rtk->ttff_isp) _rtk->ttff_isp = (unsigned int)(_getsysts() - epiod);
#define	RTKINFO_TTFF_SCL()	if (!_rtk->ttff_scl) _rtk->ttff_scl = (unsigned int)(_getsysts() - epiod);
#define	RTKINFO_TTFF_MFE()	if (!_rtk->ttff_mfe) _rtk->ttff_mfe = (unsigned int)(_getsysts() - epiod);
#define RTK_TIME_TO_US(x)   (x / 6)

struct rlink_head {
	u64             next, prev;
	u64             nphys;  // next object physical address
	unsigned int	nsize;	// next object size
	unsigned int	reserved;
};

typedef struct {
    struct rlink_head   root;
    char                name[8];
    char                version[64];
    unsigned int        verid;
    unsigned int        size;
    unsigned int        fiq_cnt;
    unsigned int        ffiq_ts;
    unsigned int        ttff_isp;
    unsigned int        ttff_scl;
    unsigned int        ttff_mfe;
    unsigned int        ldns_ts;
    u64                 start_ts;
    u64	                lifet;
    u64	                spent;
    u64                 spent_hyp;
    u64                 spent_sc;
    u64                 linux_idle_in_rtos_time;
    u64                 diff;
    unsigned int        linux_idle;
    u64                 syscall_cnt;

    // sbox must be 16-byte aligned
    unsigned char       sbox[1024];
} rtkinfo_t;

extern rtkinfo_t	*_rtk;
extern u64	epiod;

rtkinfo_t* get_rtkinfo(void);
unsigned long signal_rtos(u32 type, u32 arg1, u32 arg2, u32 arg3);
void handle_interos_nblk_call_req(void);
void handle_reroute_smc(void);

// Remote SWLA
#define INTEROS_SC_L2R_CORE_SWLA_CTRL     0xF1070000

#define SWLA_LOG_NAME_LENGTH    (8)

typedef enum
{
    SS_SWLA_LOG_START = 0,
    SS_SWLA_LOG_STOP = 1,
    SS_SWLA_LOG_LABEL = 2,
    //SS_SWLA_LOG_SWITCH_IN = 3 this type is not supported in remote side
} SS_SWLA_LOG_TYPE_e;

typedef enum
{
    SS_SWLA_DUMP_UART = 0,
    SS_SWLA_DUMP_FS = 1,
} SS_SWLA_DUMP_METHOD_e;

void remote_sys_swla_start(u32 enable_overwrite);
void remote_sys_swla_stop(void);
void remote_sys_swla_log_add_event(const char *event_name, const SS_SWLA_LOG_TYPE_e log_type, u64 ts_tick);
void remote_sys_swla_dump(SS_SWLA_DUMP_METHOD_e dump_method, const char *file_name);

#endif //__DRV_DUALOS_H__
